$(document).ready(function () {
  startup();

  function startup() {
    restorePreviousValues();

    window.socketMessageReceived = function(msg) {
      updateValuesUsing(parseVideoInputsBuffer(msg));
    };

    window.webSocket.send(0x2D, [0xF0]);
  }

  function parseVideoInputsBuffer(buffer) {
    if (buffer.length != 12) {
      throw "Invalid buffer length: " + buffer.length;
    }

    if (!validateCommandCode(buffer, 0x2D)) {
      throw "Invalid command code.";
    }

    var data = buffer.slice(5, buffer.length - 1);

    return {
      "video-input-cd": data[0],
      "video-input-aux": data[1],
      "video-input-fm": data[2],
      "video-input-dab": data[3],
      "video-input-net": data[4],
      "video-input-bt": data[5]
    };
  }

  window.encodeModel = function(model) {
    var data = new Array(6);
    data[0] = model["video-input-cd"];
    data[1] = model["video-input-aux"];
    data[2] = model["video-input-fm"];
    data[3] = model["video-input-dab"];
    data[4] = model["video-input-net"];
    data[5] = model["video-input-bt"];
    return { code: 0x2D, data: data };
  };

});
