#!/usr/bin/env sh

# redirect all output to syslog
(

# $1 - interface name

FW_PRINTCONST=/sbin/fw_printconst

ID=$(echo "$1" | sed 's/[^0-9]*//g')

wifi_addr=$($FW_PRINTCONST -n wifi_addr)
if [ $? -eq 0 ]; then
	if [ $ID -ne 0 ]; then
		# increase last byte to avoid mac address colision on multiple interfaces
		DIG=$(echo "$wifi_addr" | cut -d ":" -f 6)
		let "DIG=(0x$DIG+$ID)%256"
		wifi_addr=$(printf "%s:%02X" $(echo "$wifi_addr" | cut -d ":" -f -5) "$DIG")
	fi
	echo "Setting $1 MAC address to $wifi_addr"
	ip link set $1 address $wifi_addr
else
	echo "Could not get WiFi MAC address from const partition"
fi

) 2>&1 | logger -t broadcom-init
