#! /bin/sh

HWREVISION_FILE="/etc/hwrevision"

# Create the hwrevision file if missing
if [ ! -f $HWREVISION_FILE ]; then
	# Assuming locked if runlevel is 3
	if [ $(runlevel | cut -d" " -f 2) == 3 ]; then
		# Locked: use the real machine name, or a machine-specific override
		if [ -f /etc/hwrevision-locked ]; then
			HW_REV="$(cat /etc/hwrevision-locked)"
		else
			echo "ERROR: missing /etc/hwrevision-locked, fallback to /etc/machine"
			HW_REV="$(cat /etc/machine)"
		fi
	else
		# Unlocked: use a generic board name (e.g. GenericStream810)
		HW_REV="$(cat /etc/hwrevision-unlocked)"
	fi
	# Add module version at the end, so downgrades are avoided with incompatible modules
	if [ -f /proc/device-tree/sue/moduleversion ]; then
		HW_REV="${HW_REV}-V$(cat /proc/device-tree/sue/moduleversion)"
	fi

	echo "${HW_REV}" > ${HWREVISION_FILE}
fi
