#! /bin/sh

# google cast data folder
# yocto symlink /data -> /media/settings/google-cast-lite
dataFolder=/media/settings/google-cast-lite

# chrome home folder, storing google cast settings
homeFolder=/data/home

# store and read client.crt and client.key.bin
# yocto symlink /factory -> /data/factory
factoryFolder=/data/factory

# folder for local time symlink
# define by google cast as /data/share/chrome
localtimeFolder=/data/share/chrome


checkFolder()
{
	if [ ! -d "$1" ]; then
		if [ -e "$1" ]; then
			echo "WARNING: $1 should be a directory but is something else! Removing it."
			rm -f "$1"
		fi
		mkdir -p "$1"
	fi

	# always apply owner/permissions
	chown $2 "$1"
	chmod $3 "$1"
}

# create google cast data folders
checkFolder "$dataFolder" root:root 755
checkFolder "$factoryFolder" root:chrome 775
checkFolder "$localtimeFolder" chrome:chrome 755
checkFolder "$homeFolder" chrome:chrome 755

# increment boot id, initiate random number generator
update_bootid_and_urandom.sh

# make sure all the folders and their permissions are synced to flash asap
sync
