<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; Main Page</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			function toIpList(addresses) {
				var ips = "";
				for (var i = 0; addresses != undefined && i < addresses.length; ++i) {
					if (ips !== "")
						ips += ", "
					ips += addresses[i].ip
					if (addresses[i].prefix != undefined)
						ips += "/" + addresses[i].prefix;
				}
				return ips;
			}

			$(document).ready(function() {
				if ('<?nsdk getData path="settings:/www/ftsComplete" roles="value" escape="js" ?>' == "false" &&
					( (isFeatureEnabled("googlecast") && '<?nsdk getData path="settings:/googlecast/tosAccepted" roles="value" escape="js" ?>' == "false") ||
					  (isFeatureEnabled("googlecastlite") && '<?nsdk getData path="settings:/googleCastLite/tosAccepted" roles="value" escape="js" ?>' == "false"))
				) {
					window.location.replace("fts.fcgi");
				}

				var profile = JSON.parse('<?nsdk getData path="network:info" roles="value" escape="js"?>');

				if (profile.networkInfo === undefined) return;

				if (profile.networkInfo.wired.state == "up" && profile.networkInfo.wired.addresses != undefined) {
					$('#wiredIpDynamic').text(toIpList(profile.networkInfo.wired.addresses));
					$('#wiredInfo').show();
				}

				if (profile.networkInfo.wireless.state == "up" && profile.networkInfo.wireless.addresses != undefined) {
					$('#wirelessIpDynamic').text(toIpList(profile.networkInfo.wireless.addresses));
					$('#wirelessSsidDynamic').text(profile.networkInfo.wireless.ssid);
					$('#wirelessEncryptionDynamic').text(profile.networkInfo.wireless.encryption);
					$('#wirelesBssidDynamic').text(profile.networkInfo.wireless.bssid);
					$('#wirelessInfo').show();
				}

				if (profile.networkInfo.softAp.state == "up" && profile.networkInfo.softAp.addresses != undefined) {
					ips = "";
					for (var i = 0; i < profile.networkInfo.softAp.addresses.length; ++i) {
						if (profile.networkInfo.softAp.addresses[i].address.scope == "lincLocal")
							continue;
						if (ips !== "")
							ips += ", "
						ips += profile.networkInfo.softAp.addresses[i].address.ip + "/"
							+ profile.networkInfo.softAp.addresses[i].address.prefix
					}
					$('#apAddressDynamic').text(ips);
					$('#softApInfo').show();
				}

				if (profile.networkInfo.state == "up") {
					$('#gatewayDynamic').text(toIpList(profile.networkInfo.gateways));
					$('#dnsDynamic').text(toIpList(profile.networkInfo.dns));

					$('#globalInfo').show();
				}

				var airplay = '<?nsdk getData path="airplay:version" roles="value" escape="js"?>';

				if (!airplay.startsWith('[[')) {
					$('#airplayVersionInfo').show();
				}
			});

		</script>

	</head>

	<body>
		<div id="menu"></div>

		<fieldset id="versions">
			<legend>Versions</legend>
			<p>
				<label id="deviceVersionStatic">Device version: </label>
				<?nsdk getData path="settings:/version" roles="value" escape="html"?>
			</p>
			<div hidden id="airplayVersionInfo">
				<p>
					<label id="airplayVersionStatic">AirPlay version: </label>
					<?nsdk getData path="airplay:version" roles="value" escape="html"?>
				</p>
			</div>
		</fieldset>

		<fieldset id="currentNetworkSettings">
			<legend>Current Network Settings</legend>

			<div hidden id="wiredInfo">
				<p>
					<label id="typeStatic">Wired:</label>
				</p>

				<p>
					<label id="wiredIpStatic">IP: </label>
					<label id="wiredIpDynamic"></label>
				</p>

			</div>

			<div hidden id="wirelessInfo">
				<p>
					<label id="typeStatic">Wireless:</label>
				</p>

				<p>
					<label id="wirelessIpStatic">IP: </label>
					<label id="wirelessIpDynamic"></label>
				</p>

				<p>
					<label id="wirelessSsidStatic">SSID: </label>
					<label id="wirelessSsidDynamic"></label>
				</p>

				<p>
					<label id="wirelessEncryptionStatic">Encryption: </label>
					<label id="wirelessEncryptionDynamic"></label>
				</p>

				<p>
					<label id="wirelesBssidStatic">BSSID: </label>
					<label id="wirelesBssidDynamic"></label>
				</p>
			</div>

			<div hidden id="softApInfo">
				<p>
					<label id="apAddressStatic">Ap Address: </label>
					<label id="apAddressDynamic"></label>
				</p>
			</div>
			<div hidden id="globalInfo">
				<p>
					<label id="gatewayStatic">Gateway: </label>
					<label id="gatewayDynamic"></label>
				</p>

				<p>
					<label id="dnsStatic">DNS: </label>
					<label id="dnsDynamic"></label>
				</p>
			</div>
		</fieldset>

	</body>
</html>
