<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">
		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; Nymea</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">
		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			var enabled = false

			function updateStatus() {
				NSDK_GetData("settings:/nymea/enabled", "value")
					.done(function (data) {
						$("#nymea_enable").prop("checked", data.value.bool_)
						console.log("Got \"" + data.value.bool_ + "\"")
					})
					.fail(function (data) {
						$("#nymea_enable").prop("checked", false)
					});
			}

			$(document).ready(function () {
				updateStatus();

				$("#nymea_enable").click(function () {
					var value = $(this).is(':checked')
					NSDK_SetData("settings:/nymea/enabled", value)
						.done(function (data) {
							console.log("Set to \"" + value + "\"");
							updateStatus();
						})
						.fail(function (data) {
							console.log("Failed to set to \"" + value + "\"");
						});
				});
			});
		</script>
	</head>
	<body>
		<div id="menu"></div>

		<fieldset id="nymea">
			<legend>Nymea service</legend>
			<div id="nymea-active-content" >
				<input type=checkbox id="nymea_enable">
				<label for="nymea_enable">Enable Nymea support</label>
				<p>Nymea is an integrated smart home gateway stack, enabling seamless user experience with other devices.<br>Nymea comes with privacy by design due to autonomous operation on the edge.<br>Through nymea's plugin-base framework, interoperability can be increased anytime.</p>
				<p>Nymea works with smart home gadgets locally through WiFi, Bluetooth, ZigBee but it can also link to cloud based ecosystems like IFTTT, Tuya, and more.<br>Nymea also allows to remotely access your product.</p>
				<p>Download the nymea:app from Apple Appstore or Google Play Store and give it a try!</p>
				<p>More information on <a href="https://nymea.io/sue" target="_blank">https://nymea.io/sue</a></p>
			</div>
		</fieldset>
	</body>
</html>
